/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.StatusEffectPower;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.potion.EffectInstance;

public class StackingStatusEffectPower
extends StatusEffectPower {
    private final int minStack;
    private final int maxStack;
    private final int durationPerStack;
    private int currentStack;

    public StackingStatusEffectPower(PowerType<?> type, PlayerEntity player, int minStack, int maxStack, int durationPerStack) {
        super(type, player);
        this.minStack = minStack;
        this.maxStack = maxStack;
        this.durationPerStack = durationPerStack;
    }

    @Override
    public void tick() {
        if (this.isActive()) {
            ++this.currentStack;
            if (this.currentStack > this.maxStack) {
                this.currentStack = this.maxStack;
            }
            if (this.currentStack > 0) {
                this.applyEffects();
            }
        } else {
            --this.currentStack;
            if (this.currentStack < this.minStack) {
                this.currentStack = this.minStack;
            }
        }
    }

    @Override
    public void applyEffects() {
        this.effects.forEach(sei -> {
            int duration = this.durationPerStack * this.currentStack;
            if (duration > 0) {
                EffectInstance applySei = new EffectInstance(sei.func_188419_a(), duration, sei.func_76458_c(), sei.func_82720_e(), sei.func_188418_e(), sei.func_205348_f());
                this.player.func_195064_c(applySei);
            }
        });
    }

    @Override
    public INBT toTag() {
        return IntNBT.func_229692_a_((int)this.currentStack);
    }

    @Override
    public void fromTag(INBT tag) {
        this.currentStack = ((IntNBT)tag).func_150287_d();
    }
}

